
#ifdef BLUR_SETTINGS_BLOOM
	#define BLUR_AMOUNT 	3
	#define BLUR_SCALE 		1.0
	#define BLUR_STRENGTH 	0.25
#endif

#ifdef BLUR_SETTINGS_BLOOM_STRONG
	#define BLUR_AMOUNT 	3
	#define BLUR_SCALE 		2.5
	#define BLUR_STRENGTH 	0.35
#endif

#ifdef BLUR_SETTINGS_SSAO
	#define BLUR_AMOUNT 	3
	#define BLUR_SCALE 		4.0
	#define BLUR_STRENGTH 	0.3
#endif

uniform sampler2D texture;
varying vec2 f_texcoord;


float Gaussian (float x, float deviation)
{
	return (1.0 / sqrt(2.0 * 3.141592 * deviation)) * exp(-((x * x) / (2.0 * deviation)));
}


void main ()
{
	vec4 color = vec4(0.0);
	vec4 texColor = vec4(0.0);

	float halfBlur = float(BLUR_AMOUNT) * 0.5;
	float deviation = halfBlur * 0.35;
	deviation *= deviation;
	float strength = 1.0 - BLUR_STRENGTH;

	for(int i = 0; i < BLUR_AMOUNT; ++i)
	{
		float offset = float(i) - halfBlur;

#ifdef BLUR_DIRECTION_HORI
		vec2 texcoordOffset = vec2(offset * TEXEL_SIZE_X * BLUR_SCALE, 0.0);
#endif
#ifdef BLUR_DIRECTION_VERT
		vec2 texcoordOffset = vec2(0.0, offset * TEXEL_SIZE_Y * BLUR_SCALE);
#endif

		texColor = texture2D(texture, f_texcoord + texcoordOffset) * Gaussian(offset * strength, deviation);
		color.rgb += texColor.rgb;
	}

	color.w = 1.0;
	gl_FragColor = clamp(color, 0.0, 1.0);
}
